data "aws_iam_policy" "ecs_taskexecution" {
  arn = "arn:aws:iam::aws:policy/service-role/AmazonECSTaskExecutionRolePolicy"
}

data "aws_iam_policy_document" "assume_task_role" {
  statement {
    principals {
      type        = "Service"
      identifiers = ["ecs-tasks.amazonaws.com"]
    }

    actions = [
      "sts:AssumeRole"
    ]
  }
}

resource "aws_iam_role" "taskexec_role" {
  name = "${var.app_groupname}_${var.env_name}_taskexec_role"
  path = "/${var.app_groupname}-${var.env_name}/"

  assume_role_policy = data.aws_iam_policy_document.assume_task_role.json

  tags = merge(var.tags, { "Name" = "${var.app_groupname}_${var.env_name}_task_role" })
}

resource "aws_iam_role_policy_attachment" "ecs_taskexecution" {
  role       = aws_iam_role.taskexec_role.name
  policy_arn = data.aws_iam_policy.ecs_taskexecution.arn
}

data "aws_iam_policy_document" "parameter_store_access" {
  statement {
    actions = [
      "ssm:GetParametersByPath",
      "ssm:GetParameter",
      "ssm:GetParameters",
    ]
    resources = [
      "arn:aws:ssm:${var.region}:${data.aws_caller_identity.current.account_id}:parameter/config/${var.env_name}/${var.app_groupname}/*"
    ]
  }
}

resource "aws_iam_role_policy" "ecs_taskexecution_paramstore" {
  name = "${var.app_groupname}_${var.env_name}_parameter_store_access"
  role = aws_iam_role.taskexec_role.id

  policy = data.aws_iam_policy_document.parameter_store_access.json
}

resource "aws_iam_role" "task_role" {
  name = "${var.app_groupname}_${var.env_name}_task_role"
  path = "/${var.app_groupname}-${var.env_name}/"

  assume_role_policy = data.aws_iam_policy_document.assume_task_role.json

  tags = merge(var.tags, { "Name" = "${var.app_groupname}_${var.env_name}_task_role" })
}