variable "environment" {
  type        = map(string)
  description = "Environment variables as a normal map, could contain ssm parameters as values (full arn)."
}

locals {
  ssm_param_pattern               = "^arn:aws:ssm"
  environment_without_null_values = { for name, value in var.environment : name => value if value != null }
}

output "environment" {
  value = flatten([
    for name, value in local.environment_without_null_values : [
      {
        name  = name
        value = value
      }
    ] if length(regexall(local.ssm_param_pattern, value)) == 0
  ])
  description = "List environment"
}

output "secrets" {
  value = flatten([
    for name, value in local.environment_without_null_values : [
      {
        name      = name
        valueFrom = value
      }
    ] if length(regexall(local.ssm_param_pattern, value)) > 0
  ])
  description = "List secrect"
}
