@echo off

set JCHEMHOME=%~dp0..\..

echo .
echo . This example calculates statistics about the performance of different
echo . parametrized metrics of two molecular descriptors (pharmacophore
echo . fingerprints (basic and fuzzy) and chemical fingerprints). These metrics
echo . are used in screening a set of molecules against a set of known actives.
echo . The actives are beta2 antagonists of the adrenerg receptor. 900 molecules
echo . from the NCI database are screened.
echo .
echo .
echo . Results are written into the file 
echo . examples\output\nci-beta2-adreno-antag-Enrichment.stat.
echo .

echo . Press any key to continue (or Ctrl-C to abort)
pause

if not exist %JCHEMHOME%\examples\output\opt-CF-nci1000-beta2-adreno-antag.xml goto NotYetOptimized

pushd %JCHEMHOME%

call bin\hitstatistics config examples\config\hitstatistics.xml -v

echo .
echo . Now the output text file 
echo . examples\output\nci-beta2-adreno-antag-Enrichment.stat 
echo . containing statistics about the performance of screening with the 
echo . parametrized metrics is displayed.
echo .

echo . Press any key to continue (or Ctrl-C to abort)
pause


call more examples\output\nci-beta2-adreno-antag-Enrichment.stat

popd

goto End

:NotYetOptimized
echo .
echo . ERROR!!!
echo . File %JCHEMHOME%\examples\output\opt-CF-nci1000-beta2-adreno-antag.xml
echo . does not exists.
echo . Before executing this example 'optimizemetrics_example' should be
echo . invoked which sets the parametrized metrics.
echo .

:End
