variable "webservice_name" {
  type        = string
  description = "Short name of the webservice like 'cc-web'"
}

variable "webservice_fullname" {
  type        = string
  description = "Full name of the webservice like 'cchecker-web'"
}

variable "container_name" {
  type        = string
  default     = ""
  description = "Name of the container if differs from 'webservice_name'"
}

variable "container_image" {
  type        = string
  default     = ""
  description = "URL of the container image if you wish to override the default"
}

variable "webservice_version" {
  type        = string
  description = "Version of the webservice"
}

variable "desired_count" {
  type        = number
  description = "Number of task should be running"
}

variable "task_memory" {
  type        = number
  description = "How much memory the task get allocated"
}

variable "task_memory_reservation" {
  type        = number
  description = "How much memory from the task_memody is reserved"
}

variable "task_cpu" {
  type        = number
  description = "How much cpu unit the task get allocated"
}

variable "task_role_arn" {
  type        = string
  default     = null
  description = "ARN of the service role required for the process inside the container"
}

variable "task_environment_variables" {
  type        = map(string)
  default     = {}
  description = "Environment variables (including ssm secrets) available to the container"
}

variable "retries" {
  type        = number
  default     = 3
  description = "Number of retries for the healthcheck to detect container failure"
}

variable "grace_period" {
  type        = number
  default     = 180
  description = "Grace period in seconds for the healthcheck to detect container failure"
}

variable "webservice_port" {
  type        = number
  description = "TCP port of the container service uses"
}

variable "rds_port" {
  type        = number
  description = "TCP port of the rds service uses"
}

variable "loggroup_name" {
  type        = string
  description = "Name of the log group the container-output will be streamed"
}

variable "healthcheck_uri" {
  type        = string
  description = "The Path component of the healthcheck URL (e.g. /manage/health)"
}

variable "deployment_maximum_percent" {
  type        = number
  description = "Maximum percent of the tasks allowed to run during new deployment"
  default     = 200
}

variable "deployment_minimum_healthy_percent" {
  type        = number
  description = "Minimum percent of the tasks required to run during new deployment"
  default     = 50
}

variable "deployment_controller" {
  type        = string
  description = "Controller responsible for the deployment"
  default     = "ECS"
}

variable "vpc_name" {
  type        = string
  description = "Name of the vpc where the resources will be deployed to"
}

variable "env_name" {
  type        = string
  description = "Name of the environment"
}

variable "app_groupname" {
  type        = string
  description = "Kind of a common prefix which multiple webservice deployment could share (e.g. alarm_name = 'http_{var.app_groupname}_{var.webservice_name}_{var.env_name}_healthy_hosts')"
}

variable "tags" {
  description = "Resource tags"
}

variable "service_discovery_namespace_id" {
  type        = list(any)
  default     = []
  description = "ID (a list of just one item because of foreach) of the private dns namespace if service discovery is desirable"
}

variable "capacity_provider" {
  default     = "FARGATE"
  description = "ECS capacity provider"
}

variable "unhealthy_threshold" {
  default     = 3
  description = "Number of consecutive health check failures required before considering the target unhealthy."
}

variable "health_check_interval" {
  default     = 30
  description = "Amount of time, in seconds, during which no response means a failed health check."
}

variable "region" {
  description = "AWS region to be used by IAM and provider."
}

variable "chemaxon_license_url_ssm_name" {
  description = "SSM name of the parameter that stores the URL for Chemaxon license."
}

variable "vpc_private_tag" {
  description = "Tag of private subnets."
}

variable "db_url" {
  description = "URL of the database the service can use."
  default     = ""
}

variable "db_password_ssm_name" {
  description = "SSM name of the parameter that stores the database password which the service can use."
}

variable "db_user_ssm_name" {
  description = "SSM name of the parameter that stores the database user which the service can use."
}

variable "subdomain" {
  description = "Subdomain name for the service that can be referenced from the database."
}

variable "hosted_zone_name" {
  description = "Hosted zone domain name for the service that can be referenced from the database."
}

variable "private_zone" {
  description = "Type of the zone"
  default     = false
}

variable "db_instance_identifier" {
  description = "RDS db instance identifier"
  default     = "choral"
}
