resource "aws_route53_record" "this" {
  count = var.desired_count > 0 ? 1 : 0

  zone_id = data.aws_route53_zone.private[0].zone_id
  name    = "${var.subdomain}.${data.aws_route53_zone.private[0].name}"
  type    = "A"

  alias {
    name                   = aws_lb.lb[0].dns_name
    zone_id                = aws_lb.lb[0].zone_id
    evaluate_target_health = true
  }
}

data "aws_route53_zone" "private" {
  count        = var.desired_count > 0 ? 1 : 0
  name         = var.hosted_zone_name
  private_zone = var.private_zone
}
