resource "aws_ecs_cluster" "cluster" {
  name = "${var.app_groupname}-${var.env_name}"

  tags = merge(var.tags, { "Name" = "${var.app_groupname}-${var.env_name}" })
}

resource "aws_service_discovery_private_dns_namespace" "sd" {
  name        = "discovery-${var.app_groupname}-${var.env_name}."
  description = "${var.env_name} Service Discovery Namespace"
  vpc         = data.aws_vpc.vpc.id
}
