@echo off

set JCHEMHOME=%~dp0..\..

echo . Usage: randomscreen {target file} {actives file} {random files index}
echo . Target and actives can be chosen from the directory 
echo . 'examples\molecules', e.g.:
echo . randomscreen nci500.smiles beta2_adrenoceptor_antagonists.smiles 5

:Classpath
REM Please don't include jchem.jar in CLASSPATH,
REM because classes may conflict with the ones
REM used by the Marvin applets. Use
REM JCHEMCLASSPATH instead.
if not "%JCHEMCLASSPATH%"=="" goto Run
set JCHEMCLASSPATH=%JCHEMHOME%\lib\jchem.jar;%CLASSPATH%

:Run


REM ------------------- Generate random test files --------------  
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.RandomMoleculeSubset %1 opt-target hit-target -n 50 -v
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.RandomMoleculeSubset %2 hit-test opt-actives -p 35 -v
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.RandomMoleculeSubset opt-actives opt-test opt-query -p 50 -v
REM ------------- Optimize for SelectivityEffectiveness ---------
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.OptimizeMetrics opt-target opt-test opt-query -e 3 -H -v -f SelectivityEffectiveness -k CF -c %JCHEMHOME%\examples\config\cfp.xml -o opt-CF.xml -M Tanimotot Tanimoto -M Tanimotoa Tanimoto -a -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideana Euclidean -a -k PF -o opt-PF.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -M Tanimotot Tanimoto -M Tanimotos Tanimoto -s -M Tanimotoa Tanimoto -a -M Tanimotosa Tanimoto -s -a -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideana Euclidean -a -M Euclideanw Euclidean -w -M Euclideanwan Euclidean -w -a -n -k PF -o opt-PF-z0.3.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -z 0.3 -M Tanimotot0.3 Tanimoto -M Tanimotos0.3 Tanimoto -s -M Tanimotoa0.3 Tanimoto -a -M Tanimotosa0.3 Tanimoto -s -a -M Euclideant0.3 Euclidean -M Euclideann0.3 Euclidean -n -M Euclideana0.3 Euclidean -a -M Euclideanw0.3 Euclidean -w -M Euclideanwan0.3 Euclidean -w -a -n -k PF -o opt-PF-z0.7.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -z 0.7 -M Tanimotot0.7 Tanimoto -M Tanimotos0.7 Tanimoto -s -M Tanimotoa0.7 Tanimoto -a -M Tanimotosa0.7 Tanimoto -s -a -M Euclideant0.7 Euclidean -M Euclideann0.7 Euclidean -n -M Euclideana0.7 Euclidean -a -M Euclideanw0.7 Euclidean -w -M Euclideanwan0.7 Euclidean -w -a -n
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.HitStatistics hit-target hit-test opt-query -o %3-SE-example.stat -e 3 -g -v -H -b -k PF -c opt-PF.xml -k PF -c opt-PF-z0.3.xml -k PF -c opt-PF-z0.7.xml -k CF -c opt-CF.xml
REM ------- Optimize for Asymmetric SelectivityEffectiveness ----
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.OptimizeMetrics opt-target opt-test opt-query -e 3 -H -v -f SelectivityEffectiveness 0.3 -k CF -c %JCHEMHOME%\examples\config\cfp.xml -o opt-CF.xml -M Tanimotot Tanimoto -M Tanimotoa Tanimoto -a -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideana Euclidean -a -k PF -o opt-PF.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -M Tanimotot Tanimoto -M Tanimotos Tanimoto -s -M Tanimotoa Tanimoto -a -M Tanimotosa Tanimoto -s -a -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideana Euclidean -a -M Euclideanw Euclidean -w -M Euclideanwan Euclidean -w -a -n -k PF -o opt-PF-z0.3.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -z 0.3 -M Tanimotot0.3 Tanimoto -M Tanimotos0.3 Tanimoto -s -M Tanimotoa0.3 Tanimoto -a -M Tanimotosa0.3 Tanimoto -s -a -M Euclideant0.3 Euclidean -M Euclideann0.3 Euclidean -n -M Euclideana0.3 Euclidean -a -M Euclideanw0.3 Euclidean -w -M Euclideanwan0.3 Euclidean -w -a -n -k PF -o opt-PF-z0.7.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -z 0.7 -M Tanimotot0.7 Tanimoto -M Tanimotos0.7 Tanimoto -s -M Tanimotoa0.7 Tanimoto -a -M Tanimotosa0.7 Tanimoto -s -a -M Euclideant0.7 Euclidean -M Euclideann0.7 Euclidean -n -M Euclideana0.7 Euclidean -a -M Euclideanw0.7 Euclidean -w -M Euclideanwan0.7 Euclidean -w -a -n
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.HitStatistics hit-target hit-test opt-query -o %3-SE-asymmetric-example.stat -e 3 -g -v -l 0.3 -H -b -k PF -c opt-PF.xml -k PF -c opt-PF-z0.3.xml -k PF -c opt-PF-z0.7.xml -k CF -c opt-CF.xml
REM ------------------- Optimize for Enrichment -----------------
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.OptimizeMetrics opt-target opt-test opt-query -e 3 -H -v -f Enrichment -k CF -c %JCHEMHOME%\examples\config\cfp.xml -o opt-CF.xml -M Tanimotot Tanimoto -M Tanimotoa Tanimoto -a -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideana Euclidean -a -k PF -o opt-PF.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -M Tanimotot Tanimoto -M Tanimotos Tanimoto -s -M Tanimotoa Tanimoto -a -M Tanimotosa Tanimoto -s -a -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideana Euclidean -a -M Euclideanw Euclidean -w -M Euclideanwan Euclidean -w -a -n -k PF -o opt-PF-z0.3.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -z 0.3 -M Tanimotot0.3 Tanimoto -M Tanimotos0.3 Tanimoto -s -M Tanimotoa0.3 Tanimoto -a -M Tanimotosa0.3 Tanimoto -s -a -M Euclideant0.3 Euclidean -M Euclideann0.3 Euclidean -n -M Euclideana0.3 Euclidean -a -M Euclideanw0.3 Euclidean -w -M Euclideanwan0.3 Euclidean -w -a -n -k PF -o opt-PF-z0.7.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -z 0.7 -M Tanimotot0.7 Tanimoto -M Tanimotos0.7 Tanimoto -s -M Tanimotoa0.7 Tanimoto -a -M Tanimotosa0.7 Tanimoto -s -a -M Euclideant0.7 Euclidean -M Euclideann0.7 Euclidean -n -M Euclideana0.7 Euclidean -a -M Euclideanw0.7 Euclidean -w -M Euclideanwan0.7 Euclidean -w -a -n
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.HitStatistics hit-target hit-test opt-query -o %3-E-example.stat -e 3 -g -v -H -b -k PF -c opt-PF.xml -k PF -c opt-PF-z0.3.xml -k PF -c opt-PF-z0.7.xml -k CF -c opt-CF.xml

goto End

:End
