package chemaxon.standardizer.external;

import java.awt.BorderLayout;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import chemaxon.standardizer.actions.editors.ActionEditor;

/**
 * GUI editor provider class for {@link RemoveChargeAction}
 * 
 * @author Imre Barna
 * @since 6.0
 */
public class RemoveChargeActionEditor implements ActionEditor<RemoveChargeAction> {

    private final JPanel editorPanel;
    private JCheckBox valenceCheckBox;
    private RemoveChargeAction action;

    /**
     * Initializes the remove charge editor Initializes a panel with
     * {@link BorderLayout} and adds a {@link JCheckBox} for valences in the
     * {@link BorderLayout#CENTER} part of the layout
     */
    public RemoveChargeActionEditor() {
	super();
	editorPanel = new JPanel();
	editorPanel.add(getValenceCheckBox());
    }

    private JCheckBox getValenceCheckBox() {
	if(valenceCheckBox == null){
	    valenceCheckBox = new JCheckBox("Remove on valid valence only");
	    valenceCheckBox.addChangeListener(new ChangeListener() {

		@Override
		public void stateChanged(ChangeEvent e) {
		    action.setCheckValence(valenceCheckBox.isSelected());
		}
	    });
	}
	return valenceCheckBox;
    }

    @Override
    public JComponent getEditorComponent(RemoveChargeAction value) {
	this.action = value;
	getValenceCheckBox().setSelected(value.isCheckValence());
	return editorPanel;
    }

}
