@echo off

set JCHEMHOME=%~dp0..\..

echo .
echo . This example sets up different parametrized metrics of two molecular
echo . descriptors (pharmacophore fingerprints and chemical fingerprints). These
echo . metrics are used in screening a set of molecules against a set of known 
echo . actives. The actives are beta2 antagonists of the adrenerg receptor. 100 
echo . molecules from the NCI database are used to set the parameters of the
echo . metrics, aiming to maximize the enrichment of screening these molecules.
echo .
echo .
echo . Input is taken from the directory 'examples\molecules'.
echo . 
echo .

echo . Press any key to continue (or Ctrl-C to abort)
pause


pushd %JCHEMHOME%

call bin\optimizemetrics config examples\config\optimizemetrics.xml -v

echo .
echo . Example is complete. Setup of metrics is written into the files
echo . examples\output\opt-CF-nci1000-beta2-adreno-antag.xml 
echo .                                        (metrics of chemical fingerprints)
echo . examples\oputput\opt-PF-nci1000-beta2-adreno-antag.xml 
echo .                                   (metrics of pharmacophore fingerprints)
echo . examples\output\opt-fuzzy=0.7-PF-nci1000-beta2-adreno-antag.xml 
echo .        (metrics of normally distributed fuzzy pharmacophore fingerprints)
echo .
echo .
echo . Now 'hitstatistics_example' can be invoked to evaluate the parametrized 
echo . metrics.

popd

goto End

:End

