@echo off
set JCHEMHOME=%~dp0..\..

pushd %JCHEMHOME%

echo .
echo . In this example the pharmacophoric point types of 1000 compounds 
echo . (taken from the NCI database) are perceived.
echo . 
echo . These structures are retrieved from an SDfile (molecules\nci1000.sdf)
echo . and results are stored in nci1000-FRAG.sdf. This output file contais all 
echo . original structures along with their pharmacophore point map 
echo . (in the PMAP-FRAG tag) data. Pharmacophoric point perception uses a simple
echo . rule-base comprising 21 small molecular fragments.
echo .

echo . Press any key to continue (or Ctrl-C to abort)
pause


call bin\pmapper -c examples\config\pharma-frag.xml -o examples\output\nci1000-FRAG.sdf -S -t PMAP-FRAG examples\molecules\nci1000.sdf

echo .
echo . Now the same input file is used, and this time pharmacophore points are 
echo . identified by ion charge calculations. This takes a bit longer, though 
echo . it achieves higher accuracy.
echo . These pharmacophore maps are stored as PMAP-CALC and the output is
echo . nci1000-CALC.sdf.
echo .

echo . Press any key to continue (or Ctrl-C to abort)
pause


call bin\pmapper -c examples\config\pharma-frag.xml -o examples\output\nci1000-CALC.sdf -S -t PMAP-CALC examples\molecules\nci1000.sdf

echo . 
echo . Now the structures will be displayed in MarvinView. Structures are
echo . colored according to their pharmacophore point types as identified by
echo . the fragment based pharmacophore perception. The coloring schema is 
echo . defined in file config/PF.colors. 
echo . 
echo . 

call bin\mview -t PMAP-FRAG -p examples\config\PF.colors examples\output\nci1000-FRAG.sdf 

echo . 
echo . And now coloring according calculated point types.
echo . 

call bin\mview -t PMAP-CALC -p examples\config\PF.colors examples\output\nci1000-CALC.sdf
popd

echo . 
echo . 
echo . 
goto End


:End
