@echo off

set JCHEMHOME=%~dp0..\..

echo .
echo .
echo .
echo . Usage: optimize {target file} {actives file}
echo . Target and actives can be chosen from the directory
echo . 'examples\molecules', e.g.:
echo . optimize nci500.smiles beta2_adrenoceptor_antagonists.smiles
echo .
echo .
echo . This example generates one set of molecular files for parameter
echo . optimization and evaluation of different parametrized metrics of two
echo . molecular descriptors (pharmacophore fingerprints and chemical
echo . fingerprints). Then it performs the optimization of parameters and
echo . evaluation of the performance of the generated parametrized metrics.
echo . These metrics are used in screening a set of molecules against a set of
echo . known actives.
echo .
echo . 
echo . Results are written into the file example_statistics.stat.
echo .
echo .

:Classpath
REM Please don't include jchem.jar in CLASSPATH,
REM because classes may conflict with the ones
REM used by the Marvin applets. Use
REM JCHEMCLASSPATH instead.
if not "%JCHEMCLASSPATH%"=="" goto Run
set JCHEMCLASSPATH=%JCHEMHOME%\lib\jchem.jar;%CLASSPATH%

:Run

REM ------------------- Generate random test files --------------  
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.RandomMoleculeSubset %1 opt-target hit-target -n 50 -v
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.RandomMoleculeSubset %2 hit-test opt-actives -p 35 -v
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.RandomMoleculeSubset opt-actives opt-test opt-query -p 50 -v
REM ------------------- Optimize for Enrichment -----------------
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.OptimizeMetrics opt-target opt-test opt-query -e 3 -H -v -f Enrichment -k CF -c %JCHEMHOME%\examples\config\cfp.xml -o opt-CF.xml -M Tanimotot Tanimoto -M Tanimotoa Tanimoto -a -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideana Euclidean -a -k PF -o opt-PF.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -M Tanimotot Tanimoto -M Tanimotos Tanimoto -s -M Tanimotoa Tanimoto -a -M Tanimotosa Tanimoto -s -a -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideanwn Euclidean -w -n -M Euclideana Euclidean -a -M Euclideanwa Euclidean -w -a -M Euclideanan Euclidean -a -n -M Euclideanwan Euclidean -w -a -n -k PF -o opt-PF-z0.7.xml -c %JCHEMHOME%\examples\config\pharma-frag.xml -z 0.7 -M Tanimotot0.7 Tanimoto -M Tanimotos0.7 Tanimoto -s -M Tanimotoa0.7 Tanimoto -a -M Tanimotosa0.7 Tanimoto -s -a -M Euclideant0.7 Euclidean -M Euclideann0.7 Euclidean -n -M Euclideanwn0.7 Euclidean -w -n -M Euclideana0.7 Euclidean -a -M Euclideanwa0.7 Euclidean -w -a -M Euclideanan0.7 Euclidean -a -n -M Euclideanwan0.7 Euclidean -w -a -n 
java %JCHEM_JAVA_OPTS% -classpath "%JCHEMCLASSPATH%" chemaxon.descriptors.HitStatistics hit-target hit-test opt-query -o example_statistics.stat -e 3 -g -v -H -b -k PF -c opt-PF.xml -k PF -c opt-PF-z0.7.xml -k CF -c opt-CF.xml

echo .
echo . Now the output text file example_statistics.stat 
echo . containing statistics about the performance of screening with the 
echo . parametrized metrics is displayed.
echo .

more example_statistics.stat

goto End


:End
