@echo off

set JCHEMHOME=%~dp0..\..

echo .
echo .
echo . This example demonstrates virtual screening of a compound library stored
echo . in a relational database table. 
echo . If an RDMS other than Derby is used, variable DB have to be
echo . set in this script.
echo .
echo . ========================================================================

pushd %JCHEMHOME%


rem Derby example (keep these two lines if not RDMS set up in chemaxon\.jchem is used, otherwise comment them out)
set DB=--driver "org.apache.derby.jdbc.EmbeddedDriver" --dburl "jdbc:derby:%JCHEMHOME%\examples\output\derbyDB;create=true"

rem keep these two lines if not RDMS set up in chemaxon\.jchem is used, otherwise comment them out
rem set DB=--driver com.mysql.jdbc.Driver --dburl jdbc:mysql:\\localhost\cdexample -l dbuser -p dbpasswd

rem keep these two lines setting in chemaxon\.jchem are used, otherwise comment them out
rem set DB=
rem set DB=

rem Removing old descriptor table
call bin\generatemd d nci1000 nci1000pfp %DB% > NUL 2> NUL

rem removing old structure table
call bin\jcman d nci1000 %DB% > NUL 2> NUL

echo .
echo . Creates table nci1000 and uploads structures from file nci1000.smiles.

call bin\jcman c nci1000 %DB%
call bin\jcman a nci1000 examples\molecules\nci1000.smiles %DB%

echo .
echo . Creates a descriptor table nci1000pfp in the database, then generates 
echo . pharmacophore fingerprints and stores them in the nci1000pfp table.

call bin\generatemd c -a nci1000 -k PF nci1000pfp -c examples\config\pharma-frag.xml %DB%

echo .
echo . This pharmacophore fingerprint table will be screened for beta2 adrenoceptor 
echo . antagonists. To make this search efficient, dissimilarity metrics will 
echo . be optimized for beta2 antagonists. 

call bin\optimizemetrics examples\molecules\opt-beta2-target.smiles examples\molecules\beta2-training.smiles examples\molecules\beta2-query.smiles -k PF -c examples\config\pharma-frag.xml -H Median -o examples\output\opt-beta2.xml -l -M Euclideant Euclidean -M Euclideann Euclidean -n -M Euclideanwn Euclidean -w -n -M Euclideana Euclidean -a -M Euclideanwa Euclidean -w -a -M Euclideanan Euclidean -a -n -M Euclideanwan Euclidean -w -a -n 

echo .
echo . Optimization completed. Optimized metrics will be validated now.

call bin\hitstatistics examples\molecules\valid-beta2-target.smiles examples\molecules\beta2-spikes.smiles examples\molecules\beta2-query.smiles -k PF -c examples\output\opt-beta2.xml -M Euclideant Euclideann Euclideanwn Euclideana Euclideanwa Euclideanan Euclideanwan -e 3 -H Median -b

echo .
echo . Metrics performing the best are: weighted asymmetric Euclidean and weighted normalized asymmetric Euclidean
echo . these are added to the screening configuration stored in the database.

call bin\generatemd a nci1000 nci1000pfp "weighted asymmetric Euclidean optimized for beta2"  PharmacophoreFingerprintEuclideanwa.xml %DB%
call bin\generatemd a nci1000 nci1000pfp "weighted asymmetric normalized Euclidean optimized for beta2"  PharmacophoreFingerprintEuclideanwan.xml %DB%

echo .
echo . Compound library will be screened now for beta2 analogs using the optimized
echo . weighted asymmetric normalized Euclidean dissimilarity metric."

call bin\screenmd examples\molecules\beta2-query.smiles -a nci1000 -k nci1000pfp -M Euclideanwan -o sdf examples\output\hits.sdf %DB%

echo .
echo . Screening is completed. Hits will be displayed in MarvinView.

call bin\mview examples\output\hits.sdf 

popd

goto End

:End


