/*
 * Decompiled with CFR 0.152.
 */
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Properties;
import java.util.StringTokenizer;

public class BemisMurckoPlugin
extends CalculatorPlugin {
    private static String[] TYPE_RANGE = new String[]{"structure", "atomcount", "bondcount"};
    private Object[] types = new Object[]{"structure"};
    private Molecule mol = null;
    private String format = null;
    private boolean keepSingleForAcyclic = true;
    private boolean processOnlyLargestInputFragment = false;
    private boolean keepOnlyLargestResultFragment = false;

    public boolean isLicensed() {
        return true;
    }

    protected void setInputMolecule(Molecule molecule) throws PluginException {
        this.mol = molecule;
    }

    public void setParameters(Properties properties) throws PluginException {
        String string = properties.getProperty("type");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.types = new Object[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.checkType(string2, TYPE_RANGE);
                this.types[n++] = string2;
            }
        }
        this.format = properties.getProperty("format", "smiles");
        this.setKeepSingleAtomForAcyclic(properties.getProperty("keepsingleatom", "true").equalsIgnoreCase("true"));
        this.setProcessOnlyLargestInputFragment(properties.getProperty("lfin", "false").equalsIgnoreCase("true"));
        this.setKeepOnlyLargestResultFragment(properties.getProperty("lfout", "false").equalsIgnoreCase("true"));
    }

    public boolean handlesMultiFragmentMolecules() {
        return true;
    }

    public void setKeepSingleAtomForAcyclic(boolean bl) {
        this.keepSingleForAcyclic = bl;
    }

    public void setProcessOnlyLargestInputFragment(boolean bl) {
        this.processOnlyLargestInputFragment = bl;
    }

    public void setKeepOnlyLargestResultFragment(boolean bl) {
        this.keepOnlyLargestResultFragment = bl;
    }

    public boolean run() throws PluginException {
        this.mol = BemisMurckoPlugin.generateBemisMurckoFramework(this.mol, this.processOnlyLargestInputFragment, this.keepOnlyLargestResultFragment, this.keepSingleForAcyclic);
        return true;
    }

    private static Molecule generateBemisMurckoFramework(Molecule molecule, boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (bl) {
            molecule = BemisMurckoPlugin.getLargestFragment(molecule);
        }
        for (MolAtom molAtom : molecule.getAtomArray()) {
            molAtom.setAtno(6);
            molAtom.setFlags(0);
        }
        MolAtom[] molAtomArray = molecule.getBondArray();
        int n2 = molAtomArray.length;
        for (n = 0; n < n2; ++n) {
            MolAtom molAtom;
            molAtom = molAtomArray[n];
            molAtom.setFlags(0);
            molAtom.setType(1);
        }
        boolean bl4 = true;
        while (bl4) {
            bl4 = false;
            for (n2 = 0; !bl4 && n2 < molecule.getAtomCount(); ++n2) {
                n = molecule.getAtom(n2).getBondCount();
                if (n == 1) {
                    molecule.removeNode(n2);
                    bl4 = true;
                    continue;
                }
                if (bl3 || n != 0) continue;
                molecule.removeNode(n2);
                bl4 = true;
            }
        }
        if (bl2) {
            molecule = BemisMurckoPlugin.getLargestFragment(molecule);
        }
        return molecule;
    }

    private static Molecule getLargestFragment(Molecule molecule) {
        Molecule[] moleculeArray = molecule.cloneMolecule().convertToFrags();
        if (moleculeArray.length > 1) {
            int n = -1;
            Molecule molecule2 = null;
            for (int i = 0; i < moleculeArray.length; ++i) {
                if (moleculeArray[i].getAtomCount() <= n) continue;
                molecule2 = moleculeArray[i];
                n = molecule2.getAtomCount();
            }
            return molecule2;
        }
        return molecule;
    }

    public Molecule getBemisMurckoFramework() {
        return this.mol;
    }

    public int getBemisMurckoFrameworkAtomCount() {
        return this.getBemisMurckoFramework().getAtomCount();
    }

    public int getBemisMurckoFrameworkBondCount() {
        return this.getBemisMurckoFramework().getBondCount();
    }

    public Molecule getResultMolecule() throws PluginException {
        Molecule molecule = this.getBemisMurckoFramework();
        molecule.setProperty("Atom count", Integer.toString(this.getBemisMurckoFrameworkAtomCount()));
        molecule.setProperty("Bond count", Integer.toString(this.getBemisMurckoFrameworkBondCount()));
        return molecule;
    }

    public Object[] getResultTypes() {
        return this.types;
    }

    public Object getResult(Object object, int n) throws PluginException {
        String string = object.toString();
        if (string.equalsIgnoreCase("structure")) {
            return this.getBemisMurckoFramework();
        }
        if (string.equalsIgnoreCase("atomcount")) {
            return new Integer(this.getBemisMurckoFrameworkAtomCount());
        }
        if (string.equalsIgnoreCase("bondcount")) {
            return new Integer(this.getBemisMurckoFrameworkBondCount());
        }
        throw new PluginException("Unknown type: " + object);
    }

    public String getResultAsString(Object object, int n, Object object2) throws PluginException {
        if (object2 instanceof Molecule) {
            Molecule molecule = (Molecule)object2;
            return molecule.toFormat(this.format);
        }
        if (object2 instanceof Integer) {
            return String.valueOf((Integer)object2);
        }
        throw new PluginException("Cannot convert result to String: " + object2);
    }

    public void standardize(Molecule molecule) {
        molecule.ungroupSgroups();
        molecule.implicitizeHydrogens(255);
    }
}

