@echo off

set JCHEMHOME=%~dp0..\..

pushd %JCHEMHOME%

echo .
echo . This example screens a target library of 1000 compounds taken from 
echo . the NCI database for beta2 adrenoreceptor agonists.
echo . 
echo . Input structures are read as smiles string from molecules\nci1000.smiles.
echo . Query structures, four known beta2 antagonists are read from file 
echo . molecule\beta2_antagonists.smiles.
echo .
echo . Screening is performed simultaneously for two molecular descriptors:
echo . hashed topological fingerprint (CF) and two dimensional pharmacophore 
echo . fingerprint (PF).  Descriptors in this example are generated on-the-fly
echo . during screening.
echo . Dissimilarity calculations are performed by Tanimoto metric for CF and by
echo . Euclidean metric for PF. Thresholds for acceptance are set to 0.2 and 100,
echo . respectively.
echo . Beside comparing each individual query structure to each target structure,
echo . a minimum hypothesis is also constructed from the queries, and targets
echo . are compared to this hypothesis too.
echo .
echo . The result of the screening is a table of dissimilarity coefficients
echo . calculated. Each row corresponds to one hit from the the target structures.
echo . The first column is the unique id generated by screenmd. After this there
echo . are 10 columns grouped by queries (including the hypothesis). In 
echo . each of these five groups there are two columns, the first containes the
echo . dissimilarity value for the chemical fingerprint, the other for the
echo . pharmacophore fingerprint.
echo .
echo . The progress of the virtual screening is reported after each 100
echo . molecular structures have been processed.
echo . 
echo . 

echo . Press any key to continue (or Ctrl-C to abort)
pause

call bin\screenmd config examples\config\screenmd.xml -v 100 -C

echo . 
echo . The result table:
echo . 

call type examples\output\nci1000.table
popd

echo . 
echo . 
echo . 

goto End

:End
