@echo off

set JCHEMHOME=%~dp0..\..

echo .
echo .
echo .
echo . Usage: prescreen {target file} {actives file} {nr. of test sets}
echo . Target and actives can be chosen from the directory
echo . 'examples/molecules', e.g.:
echo . prescreen nci500.smiles beta2_adrenoceptor_antagonists.smiles 5
echo .
echo .
echo . This example performs the following tasks given number times:
echo . it generates the required test sets for parameter optimization
echo . and evaluation of different parametrized metrics of two molecular descriptors
echo . (pharmacophore fingerprints and chemical fingerprints). Then it performs 
echo . the optimization of parameters and evaluation of the performance of the
echo . generated parametrized metrics for each set. These metrics are used in 
echo . screening a set of molecules against a set of known actives. Three
echo . optimizations are performed with different goal functions: selectivity
echo . effectiveness, asymmetric selectivity effectiveness and enrichment.
echo .
echo .
echo . Results are written into the files i-[goal function]-example.stat 
echo . in the working directory, where i stands for the index of test set.
echo .
echo .

FOR /L %%i IN (1,1,%3) DO call %JCHEMHOME%\examples\bin\randomscreen %1 %2 %%i  

echo .
echo . Example is complete. Results are written into the files 
echo . i-[goal-function]-example.stat
echo . in the working directory; where i stands for the index of test set.
echo .

goto End


:End

