@echo off

set JCHEMHOME=%~dp0..\..

pushd %JCHEMHOME%

echo .
echo . This example generates two dimensional pharmacophore fingerprints
echo . for 1000 compounds taken from the NCI database.
echo . 
echo . These structures are retrieved from an SDfile (molecules\nci1000.sdf)
echo . and results are stored in nci1000-PF.sdf. This output file contais all
echo . original structures along with their pharmacophore point map
echo . (in the PMAP tag) as well as the pharmacophore fingerprints generated
echo . (in the PF tag).
echo .
echo . The progress of the descriptor generation is reported after each 100
echo . molecular structures have been processed.
echo . 
echo . 

echo . Press any key to continue (or Ctrl-C to abort)
pause


call bin\generatemd config examples\config\generatemd.xml -v 100

echo . 
echo . Now the structures will be displayed in MarvinView. Structures are
echo . colored according to their pharmacophore point types. The coloring
echo . schema is defined in file config\PF.colors.
echo . 
echo . 

call bin\mview -t PMAP -p examples\config\PF.colors examples\output\nci1000-PF.sdf

popd

echo . 
echo . 
echo . 

goto End

:End
