@echo off

set JCHEMHOME=%~dp0..\..

echo .
echo .
echo . This example shows a few chemical terms evaluations.
echo .
echo . The configuration file is 'examples/config/evaluate.xml'.
echo . The input file is 'examples/molecules/evaluate.mol'.
echo .

pushd %JCHEMHOME%


echo .
echo . The atom indexes of atoms with positive pKa:
echo . "filter('pka() > 0')"
echo .

call bin/evaluate -c examples/config/evaluate.xml -e examples/config/evaluate0.txt examples/molecules/evaluate.mol

echo .
echo . The partial charges on these atoms:
echo . "charge(filter('pka() > 0'))"
echo .

call bin/evaluate -c examples/config/evaluate.xml -e examples/config/evaluate1.txt examples/molecules/evaluate.mol

echo .
echo . The sum of these charge values:
echo . "sum(charge(filter('pka() > 0')))"
echo .

call bin/evaluate -c examples/config/evaluate.xml -e examples/config/evaluate2.txt examples/molecules/evaluate.mol

echo . 
echo . The two smallest of these charge values:
echo . "minval(charge(filter('pka() > 0')), 2)"
echo .

call bin/evaluate -c examples/config/evaluate.xml -e examples/config/evaluate3.txt examples/molecules/evaluate.mol

echo .
echo . Substructure matching conditions are checked by:
echo . (1 means true, 0 means false)
echo . "match('C1CCNCC1') && match(6,'[N:1]C=O',1)"
echo .

call bin/evaluate -c examples/config/evaluate.xml -e examples/config/evaluate4.txt examples/molecules/evaluate.mol


popd

echo .
echo .
goto End


:End
