package custom.fixers;

import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.FixesExternal;

import com.chemaxon.mapper.AutoMapper;

import custom.checkers.DuplicateAtomMapChecker;

@FixesExternal(DuplicateAtomMapChecker.DUPLICATE_ATOM_MAP_CHECKER_ERROR)
@FixerInfo(
	name = "Remap reaction",
	description = "Remaps the reaction with AutoMapper",
	actionStringToken = "remapreaction")
public class RemapReactionFixer extends AbstractStructureFixer {

	@Override
	public boolean fix(StructureCheckerResult result) {
		boolean success = false;

		// check if we are trying to fix a reaction
		if (result.getMolecule().isReaction()) {

			// clear the current mapping
			AutoMapper.unmap(result.getMolecule());

			// get complete mapping
			AutoMapper.mapReaction(result.getMolecule());
			success = true;
		}
		return success;
	}

}
