@echo off

set JCHEMHOME=%~dp0..\..

echo .
echo . This example generates 5 test sets for parameter optimization and evaluation
echo . of different parametrized metrics of two molecular descriptors
echo . (pharmacophore fingerprints and chemical fingerprints). Then it performs 
echo . the optimization of parameters and evaluation of the performance of the
echo . generated parametrized metrics for the first set. These metrics are used in 
echo . screening a set of molecules against a set of known actives. The actives 
echo . are beta2 antagonists of the adrenerg receptor. Altogether 500 molecules 
echo . from the NCI database are used to set the parameters of the
echo . metrics (50 molecules) and evaluate their performance (450 molecules).
echo . The number of molecules is low because the example is only for demonstration
echo . purposes.
echo .
echo .
echo . Input is taken from the directory 'examples\molecules'.
echo .
echo . Results are written into the file 
echo . examples\output\1-nci500.smiles-beta2_adrenoceptor_antagonists.smiles.stat 
echo .
echo .

echo . Press any key to continue (or Ctrl-C to abort)
pause


pushd %JCHEMHOME%

call bin\screeningoptimizer examples\config\screeningoptimizer.xml -v

echo .
echo . Now the output text file
echo . examples\output\1-nci500.smiles-beta2_adrenoceptor_antagonists.smiles.stat 
echo . containing statistics about the performance of screening with the 
echo . parametrized metrics is displayed.
echo .

echo . Press any key to continue (or Ctrl-C to abort)
pause


more examples\output\1-nci500.smiles-beta2_adrenoceptor_antagonists.smiles.stat

popd

goto End

:End

