/*
 * Decompiled with CFR 0.152.
 */
package com.example.demo;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@Configuration
@Order(value=1)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Value(value="${user.oauth.user.username}")
    private String username;
    @Value(value="${user.oauth.user.password}")
    private String password;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().antMatchers(new String[]{"/login", "/oauth/authorize", "/oauth/logout"})).and().authorizeRequests().anyRequest()).authenticated().and()).formLogin().permitAll();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser(this.username).password(this.passwordEncoder().encode((CharSequence)this.password)).roles(new String[]{"USER"});
    }

    @Bean
    public BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

