resource "aws_security_group" "choral_service_sg" {
  name        = "${var.env_name}-sg"
  description = "Security group for public uat load balancer"
  vpc_id      = data.aws_vpc.vpc.id
  tags = merge(
    var.tags,
    {
      "Name" = "${var.env_name}-sg"
    },
  )
}

resource "aws_security_group" "rds_security_group" {
  name        = "${var.env_name}-rds-sg"
  description = "Security group for rds access"
  vpc_id      = data.aws_vpc.vpc.id
  tags = merge(
    var.tags,
    {
      "Name" = "${var.env_name}-rds-sg"
    },
  )
}

