resource "aws_security_group_rule" "app_sg_ingress_webservice" {
  count = var.desired_count > 0 ? 1 : 0

  type                     = "ingress"
  from_port                = var.webservice_port
  to_port                  = var.webservice_port
  protocol                 = "tcp"
  source_security_group_id = aws_security_group.rds_security_group.id
  security_group_id        = aws_security_group.choral_service_sg.id
  description              = "Allow LB to access ${var.webservice_name}"
}

resource "aws_security_group_rule" "app_sg_egress_webservice" {
  count = var.desired_count > 0 ? 1 : 0

  type              = "egress"
  from_port         = 0
  to_port           = 65535
  protocol          = "all"
  cidr_blocks       = ["0.0.0.0/0"]
  security_group_id = aws_security_group.choral_service_sg.id
  description       = "Allow all egress comm"
}

resource "aws_security_group_rule" "rds_sg_ingress_ecs" {
  count = var.desired_count > 0 ? 1 : 0

  type                     = "ingress"
  from_port                = var.rds_port
  to_port                  = var.rds_port
  protocol                 = "tcp"
  source_security_group_id = aws_security_group.choral_service_sg.id
  security_group_id        = aws_security_group.rds_security_group.id
  description              = "Allow ${var.webservice_name} to access rds on port ${var.rds_port}"
}

resource "aws_security_group_rule" "rds_sg_egress_access" {
  count = var.desired_count > 0 ? 1 : 0

  type              = "egress"
  from_port         = 0
  to_port           = 65535
  protocol          = "all"
  cidr_blocks       = ["0.0.0.0/0"]
  security_group_id = aws_security_group.rds_security_group.id
  description       = "Allow all egress comm"
}
