output "rds_db_url" {
  value = local.rds_db_url
}

output "rds_vpc_security_groups" {
  value = data.aws_db_instance.choral_rds_instance.vpc_security_groups
}

output "rds_security_group_name" {
  value = aws_security_group.rds_security_group.name
}

output "rds_security_group_id" {
  value = aws_security_group.rds_security_group.id
}

output "ecs_service" {
  value = aws_ecs_service.this[0].name
}

output "aws_cli_command_to_update_rds_vpc_sg" {
  value = "aws rds modify-db-instance --db-instance-identifier ${var.db_instance_identifier} --region ${var.region} --vpc-security-group-ids ${join(" ", data.aws_db_instance.choral_rds_instance.vpc_security_groups)} ${aws_security_group.rds_security_group.id}"
}

output "route53_record" {
  value       = aws_route53_record.this[0].fqdn
  description = "Route53 record name"
}
