data "aws_caller_identity" "current" {}

data "aws_region" "current" {}

data "aws_subnets" "private_subnets" {
  filter {
    name   = "vpc-id"
    values = [data.aws_vpc.vpc.id]
  }

  tags = {
    Scope = var.vpc_private_tag
  }
}

data "aws_vpc" "vpc" {
  tags = {
    Name = var.vpc_name
  }
}

data "aws_ssm_parameter" "db_password" {
  name = var.db_password_ssm_name
}

data "aws_ssm_parameter" "db_user" {
  name = var.db_user_ssm_name
}

data "aws_ssm_parameter" "chemaxon_license_url" {
  name = var.chemaxon_license_url_ssm_name
}

data "aws_db_instance" "choral_rds_instance" {
  db_instance_identifier = var.db_instance_identifier
}
