resource "aws_lb" "lb" {
  count = var.desired_count > 0 ? 1 : 0

  name               = "${var.webservice_fullname}-lb"
  internal           = true
  load_balancer_type = "application"
  security_groups    = [aws_security_group.choral_service_sg.id, aws_security_group.rds_security_group.id]
  subnets            = data.aws_subnets.private_subnets.ids
  ip_address_type    = "ipv4"
  idle_timeout       = 3600
  tags               = var.tags
}

resource "aws_lb_listener" "http" {
  load_balancer_arn = aws_lb.lb[0].arn
  port              = "8128"
  protocol          = "HTTP"

  default_action {
    type             = "forward"
    target_group_arn = aws_lb_target_group.blue[0].arn
  }
}
