resource "aws_ecr_repository" "choral" {
  name = "choral/choral-fargate"
}

data "aws_ecr_authorization_token" "token" {}

resource "docker_image" "choral" {
  name = "${aws_ecr_repository.choral.repository_url}:latest"
  build {
    context = "."
    build_arg = {
      CHORAL_VERSION : "24.1"
    }
  }
}

resource "docker_registry_image" "choral" {
  name = docker_image.choral.name
}
