#!/bin/bash

set -x

# Vmoptions (Xmx + License)
sed -i "s/-Dchemaxon.license.url=.*$/-Dchemaxon.license.url=$CHEMAXON_LICENSE_URL/g" /opt/chemaxon/choral/choral-service.vmoptions
export XMX=${XMX:-3068m}
echo "-Xmx$XMX" >> /opt/chemaxon/choral/choral-service.vmoptions

echo "choral-service.vmoptions:"
cat /opt/chemaxon/choral/choral-service.vmoptions

# choral.conf
echo "com.chemaxon.jchem.psql.scheme=gcrdb" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.gcrdb.isSingleTable=true" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.gcrdb.singleTableName=engine_data" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.gcrdb.sqlBuilderProvider=ORACLE" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.gcrdb.jdbcUrl=$JDBC_URL" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.gcrdb.user=$JDBC_USER" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.gcrdb.password=$JDBC_PASSWORD" >> /opt/chemaxon/choral/config/choral.conf

echo "com.chemaxon.jchem.psql.label.cachePolicy=${LABEL_CACHE_POLICY:-LRU}" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.label.cachedObjectCount=${LABEL_CACHED_OBJECT_COUNT:-1000000}" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.molecule.cachePolicy=${MOLECULE_CACHE_POLICY:-LRU}" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.molecule.cachedObjectCount=${MOLECULE_CACHED_OBJECT_COUNT:-1000000}" >> /opt/chemaxon/choral/config/choral.conf
echo "com.chemaxon.jchem.psql.fingerprint.cachedObjectCount=${FINGERPRINT_CACHED_OBJECT_COUNT:-1320000}" >> /opt/chemaxon/choral/config/choral.conf

echo "choral.conf:"
cat /opt/chemaxon/choral/config/choral.conf

# application.properties
export LOG_LEVEL=${LOG_LEVEL:-INFO}
sed -i "s/logging.level.root=.*$/logging.level.root=$LOG_LEVEL/g" /opt/chemaxon/choral/config/application.properties

echo "application.properties:"
cat /opt/chemaxon/choral/config/application.properties

chmod 777 /opt/chemaxon/choral/logs

# Create an infinite loop to run container forever
export SLEEP_TIME_WHEN_LOG=${SLEEP_TIME_WHEN_LOG:-60}
/opt/chemaxon/choral/choral-service start
while true
do
  if [ "$LOG" = "true" ]
  then
    /opt/chemaxon/choral/choral-service status
    sleep $SLEEP_TIME_WHEN_LOG
  else
    sleep 1000
  fi
done

set +x
